<?php
session_start();

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in']!== true) {
    header("Location: ./login/login.php");
    exit;
}
require_once './db.php';

// 获取所有跟踪链接
$stmt = $pdo->query("SELECT * FROM links");
$links = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="zh-CN">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>网站统计系统</title>
    <link href="css/tailwind.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Noto Sans SC', sans-serif;
            color: #333;
            padding-left: 250px;
            /* 为电脑端侧边栏留出空间 */
            padding-top: 60px;
            /* 为顶部标题留出空间 */
            background-color: #f4f7fa;
        }

        /* 全局按钮样式 */
        .btn {
            padding: 12px 20px;
            min-width: 44px;
            min-height: 44px;
            border-radius: 8px;
            transition: background-color 0.3s ease;
            font-weight: 600;
        }

        /* 全局表格样式 */
        table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0 10px;
            background-color: #fff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        th {
            background-color: #e5f6ff;
            color: #1d4ed8;
            font-weight: 600;
        }

        th,
        td {
            padding: 16px;
            text-align: left;
        }

        td {
            background-color: #fff;
            border-top: 1px solid #e5e7eb;
            border-bottom: 1px solid #e5e7eb;
        }

        td:first-child {
            border-left: 1px solid #e5e7eb;
            border-top-left-radius: 8px;
            border-bottom-left-radius: 8px;
        }

        td:last-child {
            border-right: 1px solid #e5e7eb;
            border-top-right-radius: 8px;
            border-bottom-right-radius: 8px;
        }

        /* 侧边栏样式 */
        .sidebar {
            position: fixed;
            top: 75px;
            /* 从顶部标题底部开始 */
            left: 0;
            width: 250px;
            height: calc(100% - 60px);
            /* 减去顶部标题的高度 */
            background-color: #1d4ed8;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        .sidebar ul {
            list-style-type: none;
            padding: 20px;
            width: 100%;
        }

        .sidebar li {
            margin-bottom: 20px;
        }

        .sidebar a {
            display: block;
            color: #fff;
            text-decoration: none;
            font-size: 16px;
            transition: color 0.3s ease;
            padding: 10px;
        }

        .sidebar a:hover {
            color: #a7c7ff;
        }

        /* 侧边栏按钮样式，仅在手机端显示 */
        .sidebar-toggle {
            position: fixed;
            top: 20px;
            left: 20px;
            z-index: 999;
            cursor: pointer;
            display: none;
            /* 默认隐藏 */
            color: #374151;
        }

        /* 侧边栏关闭按钮样式 */
        .sidebar-close {
            position: absolute;
            top: 20px;
            right: 20px;
            cursor: pointer;
            font-size: 20px;
            color: #fff;
        }

        @media (max-width: 768px) {
            body {
                padding-left: 0;
            }

            .sidebar {
                left: -250px;
                top: 0;
                /* 在手机端恢复到顶部 */
                height: 100%;
                /* 在手机端恢复高度 */
                transition: left 0.3s ease;
                z-index: 1000;
            }

            .sidebar.active {
                left: 0;
            }

            .sidebar-toggle {
                display: block;
            }
        }

        @media (min-width: 768px) {
            .sidebar-close {
                display: none;
            }
        }

        /* 顶部标题样式 */
        .top-title {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            background-color: #fff;
            padding: 20px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            z-index: 999;
            text-align: center;
        }

        .top-title h1 {
            color: #1d4ed8;
        }

        en {
            color: #1d4ed8;
        }

        /* 按钮颜色 */
        .bg-blue-500 {
            background-color: #1d4ed8;
        }

        .bg-blue-500:hover {
            background-color: #1e40af;
        }

        .bg-green-500 {
            background-color: #16a34a;
        }

        .bg-green-500:hover {
            background-color: #15803d;
        }

        .bg-yellow-500 {
            background-color: #eab308;
        }

        .bg-yellow-500:hover {
            background-color: #ca8a04;
        }

        .bg-red-500 {
            background-color: #dc2626;
        }

        .bg-red-500:hover {
            background-color: #b91c1c;
        }
    </style>
</head>

<body class="bg-gray-100">
    <!-- 顶部标题 -->
    <div class="top-title">
        <h1 class="text-3xl font-bold text-gray-800">网站统计系统</h1>
    </div>
    <!-- 侧边栏菜单 -->
    <div class="sidebar" id="sidebar">
        <!-- 关闭按钮 -->
        <div class="sidebar-close" id="sidebar-close">
        <svg t="1751620858516" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="7026" width="20" height="20"><path d="M512 1024A512 512 0 1 1 512 0a512 512 0 0 1 0 1024zM305.956571 370.395429L447.488 512 305.956571 653.604571a45.568 45.568 0 1 0 64.438858 64.438858L512 576.512l141.604571 141.531429a45.568 45.568 0 0 0 64.438858-64.438858L576.512 512l141.531429-141.604571a45.568 45.568 0 1 0-64.438858-64.438858L512 447.488 370.395429 305.956571a45.568 45.568 0 0 0-64.438858 64.438858z" fill="#DDDDDD" p-id="7027"></path></svg>
        </div>
        <ul>
            <li>
                <a href="index.php" style="display: flex; align-items: center; white-space: nowrap;">
                    <svg t="1751618879511" class="icon" viewBox="0 0 1029 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="1513" width="20" height="20" style="margin-right: 8px;"><path d="M1001.423238 494.592q21.504 20.48 22.528 45.056t-16.384 40.96q-19.456 17.408-45.056 16.384t-40.96-14.336q-5.12-4.096-31.232-28.672t-62.464-58.88-77.824-73.728-78.336-74.24-63.488-60.416-33.792-31.744q-32.768-29.696-64.512-28.672t-62.464 28.672q-10.24 9.216-38.4 35.328t-65.024 60.928-77.824 72.704-75.776 70.656-59.904 55.808-30.208 27.136q-15.36 12.288-40.96 13.312t-44.032-15.36q-20.48-18.432-19.456-44.544t17.408-41.472q6.144-6.144 37.888-35.84t75.776-70.656 94.72-88.064 94.208-88.064 74.752-70.144 36.352-34.304q38.912-37.888 83.968-38.4t76.8 30.208q6.144 5.12 25.6 24.064t47.616 46.08 62.976 60.928 70.656 68.096 70.144 68.096 62.976 60.928 48.128 46.592zM447.439238 346.112q25.6-23.552 61.44-25.088t64.512 25.088q3.072 3.072 18.432 17.408l38.912 35.84q22.528 21.504 50.688 48.128t57.856 53.248q68.608 63.488 153.6 142.336l0 194.56q0 22.528-16.896 39.936t-45.568 18.432l-193.536 0 0-158.72q0-33.792-31.744-33.792l-195.584 0q-17.408 0-24.064 10.24t-6.656 23.552q0 6.144-0.512 31.232t-0.512 53.76l0 73.728-187.392 0q-29.696 0-47.104-13.312t-17.408-37.888l0-203.776q83.968-76.8 152.576-139.264 28.672-26.624 57.344-52.736t52.224-47.616 39.424-36.352 19.968-18.944z" p-id="1514" fill="#ffffff"></path></svg>首页
                </a>
            </li>
            <li>
                <a href="./page/view_stats.php?id=<?= $links[0]['id']?? '' ?>" style="display: flex; align-items: center; white-space: nowrap;">
                <svg t="1751619554736" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="3389" width="20" height="20" style="margin-right: 8px;"><path d="M900.7 812.3H271c-52.8 0-95.6-42.8-95.6-95.6V168.2c0-26.6-21.5-48.1-48.1-48.1s-48.1 21.5-48.1 48.1v548.6c0 105.9 85.8 191.7 191.7 191.7h629.7c26.6 0 48.1-21.5 48.1-48.1 0.1-26.5-21.5-48.1-48-48.1z" fill="#ffffff" p-id="3390"></path><path d="M285.5 720.9h101.4c20.9 0 37.9-17 37.9-37.9V407.8c0-20.9-17-37.9-37.9-37.9H285.5c-20.9 0-37.9 17-37.9 37.9V683c0 20.9 17 37.9 37.9 37.9zM553.2 720.9H631c27.4 0 49.7-22.3 49.7-49.7V167.6c0-27.4-22.3-49.7-49.7-49.7h-77.8c-27.5 0-49.7 22.3-49.7 49.7v503.6c0 27.4 22.3 49.7 49.7 49.7zM802 720.9h92.1c23.5 0 42.6-19.1 42.6-42.6V321.2c0-23.5-19.1-42.6-42.6-42.6H802c-23.5 0-42.6 19.1-42.6 42.6v357.1c0 23.5 19.1 42.6 42.6 42.6z" fill="#ffffff" p-id="3391"></path></svg>查看统计
                </a>
            </li>
            <li>
                <a href="./login/logout.php" style="display: flex; align-items: center; white-space: nowrap;">
                <svg t="1751619792972" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="4451" width="20" height="20" style="margin-right: 8px;"><path d="M0 192v640c0 70.7 57.3 128 128 128h352c17.7 0 32-14.3 32-32s-14.3-32-32-32H128c-35.3 0-64-28.7-64-64V192c0-35.3 28.7-64 64-64h352c17.7 0 32-14.3 32-32s-14.3-32-32-32H128C57.3 64 0 121.3 0 192z" p-id="4452" fill="#ffffff"></path><path d="M1013.3 535.7L650.9 863.3c-41.1 37.2-106.9 8-106.9-47.5V685c0-4.4-3.6-8-8-8H224c-17.7 0-32-14.3-32-32V379c0-17.7 14.3-32 32-32h312c4.4 0 8-3.6 8-8V208.1c0-55.5 65.8-84.7 106.9-47.5l362.4 327.6c14.1 12.8 14.1 34.8 0 47.5z" p-id="4453" fill="#ffffff"></path></svg> 注销登录
                </a>
            </li>
        </ul>
    </div>
    <!-- 侧边栏切换按钮 -->
    <div class="sidebar-toggle" id="sidebar-toggle">
    <svg t="1751620354132" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="5527" width="20" height="20" style="margin-top: 8px;"><path d="M892.928 128q28.672 0 48.64 19.968t19.968 48.64l0 52.224q0 28.672-19.968 48.64t-48.64 19.968l-759.808 0q-28.672 0-48.64-19.968t-19.968-48.64l0-52.224q0-28.672 19.968-48.64t48.64-19.968l759.808 0zM892.928 448.512q28.672 0 48.64 19.968t19.968 48.64l0 52.224q0 28.672-19.968 48.64t-48.64 19.968l-759.808 0q-28.672 0-48.64-19.968t-19.968-48.64l0-52.224q0-28.672 19.968-48.64t48.64-19.968l759.808 0zM892.928 769.024q28.672 0 48.64 19.968t19.968 48.64l0 52.224q0 28.672-19.968 48.64t-48.64 19.968l-759.808 0q-28.672 0-48.64-19.968t-19.968-48.64l0-52.224q0-28.672 19.968-48.64t48.64-19.968l759.808 0z" p-id="5528" fill="#8a8a8a"></path></svg>
    </div>

    <div class="container mx-auto py-8 px-4">

        <en style="font-size: 20px; font-weight: bold;">网站统计系统 - 链接管理</en>
        <div class="mb-8" style="margin-top: 20px;">
            <form method="post" action="./config/add_link.php" class="flex flex-col md:flex-row space-y-4 md:space-y-0">
                <input type="text" name="link_name" placeholder="输入链接名称" required
                    class="border border-gray-300 rounded-md px-4 py-2 flex-1 btn">
                <button type="submit"
                    class="bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded-md btn">添加新链接</button>
            </form>
        </div>

        <?php if ($links): ?>
            <div class="overflow-x-auto">
                <table class="min-w-max">
                    <thead>
                        <tr>
                            <th>链接名称</th>
                            <th>链接地址</th>
                            <th>操作</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($links as $link):
                            $currentDir = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\');
                            $linkUrl = "http://" . $_SERVER['HTTP_HOST'] . ($currentDir === '' ? '' : $currentDir) . "/stat.php?link=" . urlencode($link['url_key']);
                            ?>
                            <tr>
                                <td><?= htmlspecialchars($link['name']) ?></td>
                                <td class="break-all">&lt;script src="<?= $linkUrl ?>"&gt;&lt;/script&gt;</td>
                                <td>
                                    <a href="./page/view_stats.php?id=<?= $link['id'] ?>"
                                        class="bg-green-500 hover:bg-green-600 text-white font-bold py-2 px-4 rounded-md btn">查看统计</a>
                                    <button onclick="copyLink('<?= $linkUrl ?>')"
                                        class="bg-yellow-500 hover:bg-yellow-600 text-white font-bold py-2 px-4 rounded-md btn">复制链接</button>
                                    <a href="./config/delete_link.php?id=<?= $link['id'] ?>"
                                        onclick="return confirm('确定要删除吗？')"
                                        class="bg-red-500 hover:bg-red-600 text-white font-bold py-2 px-4 rounded-md btn">删除</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p class="text-gray-600">还没有添加任何链接。</p>
        <?php endif; ?>
    </div>

    <script>
        const sidebar = document.getElementById('sidebar');
        const sidebarToggle = document.getElementById('sidebar-toggle');
        const sidebarClose = document.getElementById('sidebar-close');

        sidebarToggle.addEventListener('click', () => {
            sidebar.classList.toggle('active');
        });

        sidebarClose.addEventListener('click', () => {
            sidebar.classList.remove('active');
        });

        // 点击右侧空白页关闭菜单
        document.addEventListener('click', (event) => {
            if (!sidebar.contains(event.target) &&!sidebarToggle.contains(event.target)) {
                sidebar.classList.remove('active');
            }
        });

        function copyLink(link) {
            // 构建包含 script 标签的完整链接
            const scriptLink = `<script src="${link}"><\/script>`;

            // 创建一个临时的 textarea 元素
            const textarea = document.createElement('textarea');
            textarea.value = scriptLink;
            document.body.appendChild(textarea);

            // 选中 textarea 中的文本
            textarea.select();
            textarea.setSelectionRange(0, 99999);

            try {
                // 尝试使用 document.execCommand('copy') 复制文本
                const successful = document.execCommand('copy');
                if (successful) {
                    alert('复制成功，将链接粘贴到<head>标签里面');
                } else {
                    console.error('复制失败，尝试使用新的剪贴板 API');
                    // 如果 document.execCommand 失败，尝试使用新的剪贴板 API
                    navigator.clipboard.writeText(scriptLink)
                       .then(() => {
                            alert('复制成功，将链接粘贴到<head>标签里面');
                        })
                       .catch((err) => {
                            console.error('复制失败:', err);
                        });
                }
            } catch (err) {
                console.error('复制失败:', err);
                // 如果 document.execCommand 抛出错误，尝试使用新的剪贴板 API
                navigator.clipboard.writeText(scriptLink)
                   .then(() => {
                        alert('复制成功，将链接粘贴到<head>标签里面');
                    })
                   .catch((err) => {
                        console.error('复制失败:', err);
                    });
            }

            // 移除临时的 textarea 元素
            document.body.removeChild(textarea);
        }
    </script>
</body>

</html>