<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>登录</title>
    <link href="../css/tailwind.min.css" rel="stylesheet">

</head>
<body class="bg-gray-100 font-sans">
    <div class="container mx-auto py-8 px-4 flex justify-center items-center h-screen">
        <form method="post" action="../authenticate.php" class="bg-white p-8 rounded-md shadow-md w-full max-w-md">
            <h1 class="text-3xl font-bold text-gray-800 mb-6 text-center">登录</h1>
            <?php if (isset($_GET['error']) && $_GET['error'] == 1): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4 w-full text-center">
                    账号或密码错误，请重试。
                </div>
            <?php endif; ?>
            <div class="mb-4">
                <label for="username" class="block text-gray-700 text-sm font-bold mb-2">用户名</label>
                <input type="text" id="username" name="username" required class="border border-gray-300 rounded-md px-4 py-2 w-full">
            </div>
            <div class="mb-6">
                <label for="password" class="block text-gray-700 text-sm font-bold mb-2">密码</label>
                <input type="password" id="password" name="password" required class="border border-gray-300 rounded-md px-4 py-2 w-full">
            </div>
            <button type="submit" class="bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded-md w-full">登录</button>
        </form>
    </div>
</body>
</html>