<?php
session_start();

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in']!== true) {
    header("Location: ../login/login.php");
    exit;
}
require_once '../db.php';

if (!isset($_GET['id'])) {
    header("Location: index.php");
    exit;
}

$linkId = $_GET['id'];

// 获取链接信息
$stmt = $pdo->prepare("SELECT * FROM links WHERE id = ?");
$stmt->execute([$linkId]);
$link = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$link) {
    header("Location: index.php");
    exit;
}

// 获取所有链接
$stmt = $pdo->query("SELECT * FROM links");
$allLinks = $stmt->fetchAll(PDO::FETCH_ASSOC);

// 获取基础统计信息
$stmt = $pdo->prepare("SELECT 
    COUNT(*) AS total_visits,
    SUM(CASE WHEN is_new_user = 1 THEN 1 ELSE 0 END) AS new_users,
    COUNT(DISTINCT ip) AS unique_ips,
    MAX(visited_at) AS last_visited
FROM statistics WHERE link_id = ?");
$stmt->execute([$linkId]);
$stats = $stmt->fetch(PDO::FETCH_ASSOC);

// 获取当天访问量
$stmt = $pdo->prepare("SELECT COUNT(*) FROM statistics WHERE link_id = ? AND DATE(visited_at) = CURDATE()");
$stmt->execute([$linkId]);
$today_visits = $stmt->fetchColumn();

// 获取本周访问量（周一为一周的第一天）
$stmt = $pdo->prepare("SELECT COUNT(*) FROM statistics WHERE link_id = ? AND YEARWEEK(visited_at, 1) = YEARWEEK(CURDATE(), 1)");
$stmt->execute([$linkId]);
$week_visits = $stmt->fetchColumn();

// 获取本月访问量
$stmt = $pdo->prepare("SELECT COUNT(*) FROM statistics WHERE link_id = ? AND YEAR(visited_at) = YEAR(CURDATE()) AND MONTH(visited_at) = MONTH(CURDATE())");
$stmt->execute([$linkId]);
$month_visits = $stmt->fetchColumn();

// 获取最近30天访问量
$stmt = $pdo->prepare("SELECT COUNT(*) FROM statistics WHERE link_id = ? AND visited_at >= DATE_SUB(CURDATE(), INTERVAL 30 DAY)");
$stmt->execute([$linkId]);
$last30_visits = $stmt->fetchColumn();

// 获取当天独立IP数
$stmt = $pdo->prepare("SELECT COUNT(DISTINCT ip) FROM statistics WHERE link_id = ? AND DATE(visited_at) = CURDATE()");
$stmt->execute([$linkId]);
$today_unique_ips = $stmt->fetchColumn();

// 获取本周独立IP数
$stmt = $pdo->prepare("SELECT COUNT(DISTINCT ip) FROM statistics WHERE link_id = ? AND YEARWEEK(visited_at, 1) = YEARWEEK(CURDATE(), 1)");
$stmt->execute([$linkId]);
$week_unique_ips = $stmt->fetchColumn();

// 获取本月独立IP数
$stmt = $pdo->prepare("SELECT COUNT(DISTINCT ip) FROM statistics WHERE link_id = ? AND YEAR(visited_at) = YEAR(CURDATE()) AND MONTH(visited_at) = MONTH(CURDATE())");
$stmt->execute([$linkId]);
$month_unique_ips = $stmt->fetchColumn();

// 获取最近30天独立IP数
$stmt = $pdo->prepare("SELECT COUNT(DISTINCT ip) FROM statistics WHERE link_id = ? AND visited_at >= DATE_SUB(CURDATE(), INTERVAL 30 DAY)");
$stmt->execute([$linkId]);
$last30_unique_ips = $stmt->fetchColumn();

// 获取近7天每天的访问量和独立IP数
$seven_days = [];
$seven_days_visits = [];
$seven_days_unique_ips = [];
for ($i = 6; $i >= 0; $i--) {
    $date = date('Y-m-d', strtotime("-$i day"));
    $seven_days[] = $date;
    // 访问量
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM statistics WHERE link_id = ? AND DATE(visited_at) = ?");
    $stmt->execute([$linkId, $date]);
    $seven_days_visits[] = (int)$stmt->fetchColumn();
    // 独立IP
    $stmt = $pdo->prepare("SELECT COUNT(DISTINCT ip) FROM statistics WHERE link_id = ? AND DATE(visited_at) = ?");
    $stmt->execute([$linkId, $date]);
    $seven_days_unique_ips[] = (int)$stmt->fetchColumn();
}
// 反转数组，使当天在最右边，第7天在最左边
$seven_days = array_reverse($seven_days);
$seven_days_visits = array_reverse($seven_days_visits);
$seven_days_unique_ips = array_reverse($seven_days_unique_ips);

// 每页显示的记录数
$limit = 10;

// 获取当前页码
$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
if ($page < 1) {
    $page = 1;
}

// 计算偏移量
$offset = ($page - 1) * $limit;

// 获取最近访问记录
$stmt = $pdo->prepare("SELECT * FROM statistics WHERE link_id = ? ORDER BY visited_at DESC LIMIT $offset, $limit");
$stmt->execute([$linkId]);
$recentVisits = $stmt->fetchAll(PDO::FETCH_ASSOC);

// 获取总记录数
$stmt = $pdo->prepare("SELECT COUNT(*) AS total_records FROM statistics WHERE link_id = ?");
$stmt->execute([$linkId]);
$totalRecords = $stmt->fetch(PDO::FETCH_ASSOC)['total_records'];

// 计算总页数
$totalPages = ceil($totalRecords / $limit);














?>







<!DOCTYPE html>
<html lang="zh-CN">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>网站统计系统</title>

    <link href="../css/tailwind.min.css" rel="stylesheet">
    <script src="../js/chart.umd.min.js"></script>
    <script src="../js/chartjs-plugin-datalabels.min.js"></script>
    <style>
        body {
            font-family: 'Noto Sans SC', sans-serif;
            color: #333;
            padding-left: 250px;
            /* 为电脑端侧边栏留出空间 */
            padding-top: 60px;
            /* 为顶部标题留出空间 */
            background-color: #f4f7fa;
        }

        /* 全局按钮样式 */
        .btn {
            padding: 12px 20px;
            min-width: 44px;
            min-height: 44px;
            border-radius: 8px;
            transition: background-color 0.3s ease;
            font-weight: 600;
        }

        /* 全局表格样式 */
        table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0 10px;
            background-color: #fff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        th {
            background-color: #e5f6ff;
            color: #1d4ed8;
            font-weight: 600;
        }

        th,
        td {
            padding: 16px;
            text-align: left;
        }

        td {
            background-color: #fff;
            border-top: 1px solid #e5e7eb;
            border-bottom: 1px solid #e5e7eb;
        }

        td:first-child {
            border-left: 1px solid #e5e7eb;
            border-top-left-radius: 8px;
            border-bottom-left-radius: 8px;
        }

        td:last-child {
            border-right: 1px solid #e5e7eb;
            border-top-right-radius: 8px;
            border-bottom-right-radius: 8px;
        }

        /* 侧边栏样式 */
        .sidebar {
            position: fixed;
            top: 75px;
            /* 从顶部标题底部开始 */
            left: 0;
            width: 250px;
            height: calc(100% - 60px);
            /* 减去顶部标题的高度 */
            background-color: #1d4ed8;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        .sidebar ul {
            list-style-type: none;
            padding: 20px;
            width: 100%;
        }

        .sidebar li {
            margin-bottom: 20px;
        }

        .sidebar a {
            display: block;
            color: #fff;
            text-decoration: none;
            font-size: 16px;
            transition: color 0.3s ease;
            padding: 10px;
        }

        .sidebar a:hover {
            color: #a7c7ff;
        }

        /* 侧边栏按钮样式，仅在手机端显示 */
        .sidebar-toggle {
            position: fixed;
            top: 20px;
            left: 20px;
            z-index: 999;
            cursor: pointer;
            display: none;
            /* 默认隐藏 */
            color: #374151;
        }

        /* 侧边栏关闭按钮样式 */
        .sidebar-close {
            position: absolute;
            top: 20px;
            right: 20px;
            cursor: pointer;
            font-size: 20px;
            color: #fff;
        }

        @media (max-width: 768px) {
            body {
                padding-left: 0;
            }

            .sidebar {
                left: -250px;
                top: 0;
                /* 在手机端恢复到顶部 */
                height: 100%;
                /* 在手机端恢复高度 */
                transition: left 0.3s ease;
                z-index: 1000;
            }

            .sidebar.active {
                left: 0;
            }

            .sidebar-toggle {
                display: block;
            }
        }

        @media (min-width: 768px) {
            .sidebar-close {
                display: none;
            }
        }

        /* 顶部标题样式 */
        .top-title {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            background-color: #fff;
            padding: 20px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            z-index: 999;
            text-align: center;
        }

        .top-title h1 {
            color: #1d4ed8;
        }

        en {
            color: #1d4ed8;
        }

        /* 按钮颜色 */
        .bg-gray-500 {
            background-color: #6b7280;
        }

        .bg-gray-500:hover {
            background-color: #4b5563;
        }

        /* 统计卡片样式 */
        .stat-card {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            text-align: center;
        }

        .stat-card .value {
            font-size: 24px;
            font-weight: bold;
            color: #1d4ed8;
        }

        .stat-card .label {
            font-size: 14px;
            color: #6b7280;
        }

        canvas {
            width: 100% !important;
            height: auto !important;
            max-width: 100%;
            display: block;
        }

        @media (max-width: 768px) {
            .container, .bg-white {
                width: 100% !important;
                max-width: 100% !important;
                padding: 8px !important;
                margin-top: 20px;
            }
        }
    </style>
</head>

<body class="bg-gray-100">

    <!-- 顶部标题 -->
    <div class="top-title">
        <h1 class="text-3xl font-bold text-gray-800">网站统计系统</h1>
    </div>
    <!-- 侧边栏菜单 -->
    <div class="sidebar" id="sidebar">
        <!-- 关闭按钮 -->
        <div class="sidebar-close" id="sidebar-close">
        <svg t="1751620858516" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="7026" width="20" height="20"><path d="M512 1024A512 512 0 1 1 512 0a512 512 0 0 1 0 1024zM305.956571 370.395429L447.488 512 305.956571 653.604571a45.568 45.568 0 1 0 64.438858 64.438858L512 576.512l141.604571 141.531429a45.568 45.568 0 0 0 64.438858-64.438858L576.512 512l141.531429-141.604571a45.568 45.568 0 1 0-64.438858-64.438858L512 447.488 370.395429 305.956571a45.568 45.568 0 0 0-64.438858 64.438858z" fill="#DDDDDD" p-id="7027"></path></svg>
        </div>
        <ul>
            <li>
                <a href="../index.php" style="display: flex; align-items: center; white-space: nowrap;">
                    <svg t="1751618879511" class="icon" viewBox="0 0 1029 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="1513" width="20" height="20" style="margin-right: 8px;"><path d="M1001.423238 494.592q21.504 20.48 22.528 45.056t-16.384 40.96q-19.456 17.408-45.056 16.384t-40.96-14.336q-5.12-4.096-31.232-28.672t-62.464-58.88-77.824-73.728-78.336-74.24-63.488-60.416-33.792-31.744q-32.768-29.696-64.512-28.672t-62.464 28.672q-10.24 9.216-38.4 35.328t-65.024 60.928-77.824 72.704-75.776 70.656-59.904 55.808-30.208 27.136q-15.36 12.288-40.96 13.312t-44.032-15.36q-20.48-18.432-19.456-44.544t17.408-41.472q6.144-6.144 37.888-35.84t75.776-70.656 94.72-88.064 94.208-88.064 74.752-70.144 36.352-34.304q38.912-37.888 83.968-38.4t76.8 30.208q6.144 5.12 25.6 24.064t47.616 46.08 62.976 60.928 70.656 68.096 70.144 68.096 62.976 60.928 48.128 46.592zM447.439238 346.112q25.6-23.552 61.44-25.088t64.512 25.088q3.072 3.072 18.432 17.408l38.912 35.84q22.528 21.504 50.688 48.128t57.856 53.248q68.608 63.488 153.6 142.336l0 194.56q0 22.528-16.896 39.936t-45.568 18.432l-193.536 0 0-158.72q0-33.792-31.744-33.792l-195.584 0q-17.408 0-24.064 10.24t-6.656 23.552q0 6.144-0.512 31.232t-0.512 53.76l0 73.728-187.392 0q-29.696 0-47.104-13.312t-17.408-37.888l0-203.776q83.968-76.8 152.576-139.264 28.672-26.624 57.344-52.736t52.224-47.616 39.424-36.352 19.968-18.944z" p-id="1514" fill="#ffffff"></path></svg>首页
                </a>
            </li>
            <li>
                <a href="./view_stats.php?id=<?= $allLinks[0]['id']?? '' ?>"" style="display: flex; align-items: center; white-space: nowrap;">
                    <svg t="1751619554736" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="3389" width="20" height="20" style="margin-right: 8px;"><path d="M900.7 812.3H271c-52.8 0-95.6-42.8-95.6-95.6V168.2c0-26.6-21.5-48.1-48.1-48.1s-48.1 21.5-48.1 48.1v548.6c0 105.9 85.8 191.7 191.7 191.7h629.7c26.6 0 48.1-21.5 48.1-48.1 0.1-26.5-21.5-48.1-48-48.1z" fill="#ffffff" p-id="3390"></path><path d="M285.5 720.9h101.4c20.9 0 37.9-17 37.9-37.9V407.8c0-20.9-17-37.9-37.9-37.9H285.5c-20.9 0-37.9 17-37.9 37.9V683c0 20.9 17 37.9 37.9 37.9zM553.2 720.9H631c27.4 0 49.7-22.3 49.7-49.7V167.6c0-27.4-22.3-49.7-49.7-49.7h-77.8c-27.5 0-49.7 22.3-49.7 49.7v503.6c0 27.4 22.3 49.7 49.7 49.7zM802 720.9h92.1c23.5 0 42.6-19.1 42.6-42.6V321.2c0-23.5-19.1-42.6-42.6-42.6H802c-23.5 0-42.6 19.1-42.6 42.6v357.1c0 23.5 19.1 42.6 42.6 42.6z" fill="#ffffff" p-id="3391"></path></svg>查看统计
                </a>
            </li>
            <li>
                <a href="../login/logout.php" style="display: flex; align-items: center; white-space: nowrap;">
                    <svg t="1751619792972" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="4451" width="20" height="20" style="margin-right: 8px;"><path d="M0 192v640c0 70.7 57.3 128 128 128h352c17.7 0 32-14.3 32-32s-14.3-32-32-32H128c-35.3 0-64-28.7-64-64V192c0-35.3 28.7-64 64-64h352c17.7 0 32-14.3 32-32s-14.3-32-32-32H128C57.3 64 0 121.3 0 192z" p-id="4452" fill="#ffffff"></path><path d="M1013.3 535.7L650.9 863.3c-41.1 37.2-106.9 8-106.9-47.5V685c0-4.4-3.6-8-8-8H224c-17.7 0-32-14.3-32-32V379c0-17.7 14.3-32 32-32h312c4.4 0 8-3.6 8-8V208.1c0-55.5 65.8-84.7 106.9-47.5l362.4 327.6c14.1 12.8 14.1 34.8 0 47.5z" p-id="4453" fill="#ffffff"></path></svg> 注销登录
                </a>
            </li>
        </ul>
    </div>
    <!-- 侧边栏切换按钮 -->
    <div class="sidebar-toggle" id="sidebar-toggle">
    <svg t="1751620354132" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="5527" width="20" height="20" style="margin-top: 8px;"><path d="M892.928 128q28.672 0 48.64 19.968t19.968 48.64l0 52.224q0 28.672-19.968 48.64t-48.64 19.968l-759.808 0q-28.672 0-48.64-19.968t-19.968-48.64l0-52.224q0-28.672 19.968-48.64t48.64-19.968l759.808 0zM892.928 448.512q28.672 0 48.64 19.968t19.968 48.64l0 52.224q0 28.672-19.968 48.64t-48.64 19.968l-759.808 0q-28.672 0-48.64-19.968t-19.968-48.64l0-52.224q0-28.672 19.968-48.64t48.64-19.968l759.808 0zM892.928 769.024q28.672 0 48.64 19.968t19.968 48.64l0 52.224q0 28.672-19.968 48.64t-48.64 19.968l-759.808 0q-28.672 0-48.64-19.968t-19.968-48.64l0-52.224q0-28.672 19.968-48.64t48.64-19.968l759.808 0z" p-id="5528" fill="#8a8a8a"></path></svg>
    </div>

    <div class="container mx-auto py-8 px-4">
        <!-- <h1 class="text-3xl font-bold text-gray-800 mb-6"><?= htmlspecialchars($link['name']) ?> 统计详情</h1> -->

        <div class="mb-8">
            <select onchange="window.location.href='view_stats.php?id=' + this.value"
                class="border border-gray-300 rounded-md px-4 py-2 btn">
                <?php foreach ($allLinks as $l): ?>
                    <option value="<?= $l['id'] ?>" <?= $l['id'] == $linkId? 'selected' : ''?>>
                        <?= htmlspecialchars($l['name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <en style="font-size: 20px; font-weight: bold;">统计详情</en>
        </div>

        <div class="bg-white p-6 rounded-md shadow-md mb-8">
            <h3 class="text-lg font-bold text-gray-800 mb-4">访问量与独立IP统计</h3>
            <canvas id="mainStatsChart"></canvas>
            <div class="grid grid-cols-2 md:grid-cols-4 gap-6 mt-8">
                <div class="stat-card">
                    <div class="value"><?= $stats['total_visits'] ?></div>
                    <div class="label">总浏览次数</div>
                </div>
                <div class="stat-card">
                    <div class="value"><?= $stats['new_users'] ?></div>
                    <div class="label">新用户数</div>
                </div>
                <div class="stat-card">
                    <div class="value"><?= $stats['unique_ips'] ?></div>
                    <div class="label">独立IP数</div>
                </div>
                <div class="stat-card">
                    <div class="value"><?= $stats['last_visited']? date('Y-m-d H:i', strtotime($stats['last_visited'])) : 'N/A' ?></div>
                    <div class="label">最后访问时间</div>
                </div>
            </div>
        </div>

        <div class="bg-white p-6 rounded-md shadow-md mb-8">
            <h3 class="text-lg font-bold text-gray-800 mb-4">近7天访问量与独立IP趋势</h3>
            <canvas id="lineStatsChart"></canvas>
        </div>

        <div id="visit-records">
            <?php require 'visit_records.php'; ?>
        </div>
    </div>

    <script>
        const sidebar = document.getElementById('sidebar');
        const sidebarToggle = document.getElementById('sidebar-toggle');
        const sidebarClose = document.getElementById('sidebar-close');

        sidebarToggle.addEventListener('click', () => {
            sidebar.classList.toggle('active');
        });

        sidebarClose.addEventListener('click', () => {
            sidebar.classList.remove('active');
        });

        // 点击右侧空白页关闭菜单
        document.addEventListener('click', (event) => {
            if (!sidebar.contains(event.target) &&!sidebarToggle.contains(event.target)) {
                sidebar.classList.remove('active');
            }
        });

        // 访问量与独立IP统计图表
        // 响应式字体大小函数
        function getResponsiveFontSize() {
            if (window.innerWidth < 400) return 10;
            if (window.innerWidth < 600) return 12;
            if (window.innerWidth < 900) return 14;
            return 16;
        }
        const mainStatsData = {
            labels: ['当天', '本周', '本月', '最近30天'],
            datasets: [
                {
                    label: '访问量',
                    data: [
                        <?= $today_visits ?>,
                        <?= $week_visits ?>,
                        <?= $month_visits ?>,
                        <?= $last30_visits ?>
                    ],
                    backgroundColor: 'rgba(59, 130, 246, 0.7)',
                    borderColor: 'rgba(59, 130, 246, 1)',
                    borderWidth: 2
                },
                {
                    label: '独立IP',
                    data: [
                        <?= $today_unique_ips ?>,
                        <?= $week_unique_ips ?>,
                        <?= $month_unique_ips ?>,
                        <?= $last30_unique_ips ?>
                    ],
                    backgroundColor: 'rgba(16, 185, 129, 0.7)',
                    borderColor: 'rgba(16, 185, 129, 1)',
                    borderWidth: 2
                }
            ]
        };
        const ctxMain = document.getElementById('mainStatsChart').getContext('2d');
        let mainChart = new Chart(ctxMain, {
            type: 'bar',
            data: mainStatsData,
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        display: true,
                        position: 'bottom',
                        labels: {
                            font: {
                                size: getResponsiveFontSize()
                            }
                        }
                    },
                    title: { display: false },
                    datalabels: {
                        anchor: 'end',
                        align: 'end',
                        color: '#333',
                        font: {
                            weight: 'bold',
                            size: getResponsiveFontSize()
                        },
                        formatter: function(value) {
                            return value;
                        }
                    }
                },
                scales: {
                    x: {
                        ticks: {
                            font: {
                                size: getResponsiveFontSize()
                            },
                            padding: 16,
                            labelOffset: 8
                        }
                    },
                    y: {
                        beginAtZero: true,
                        suggestedMax: Math.max(...mainStatsData.datasets[0].data, ...mainStatsData.datasets[1].data) * 1.2,
                        ticks: {
                            font: {
                                size: getResponsiveFontSize()
                            }
                        }
                    }
                }
            },
            plugins: [ChartDataLabels]
        });
        // 窗口大小变化时自适应刷新字体
        window.addEventListener('resize', () => {
            mainChart.options.plugins.legend.labels.font.size = getResponsiveFontSize();
            mainChart.options.plugins.datalabels.font.size = getResponsiveFontSize();
            mainChart.options.scales.x.ticks.font.size = getResponsiveFontSize();
            mainChart.options.scales.y.ticks.font.size = getResponsiveFontSize();
            mainChart.update();
        });

        // 近7天数据（由PHP输出）
        const sevenDaysLabels = <?= json_encode($seven_days) ?>;
        const sevenDaysVisits = <?= json_encode($seven_days_visits) ?>;
        const sevenDaysUniqueIps = <?= json_encode($seven_days_unique_ips) ?>;
        const ctxLine = document.getElementById('lineStatsChart').getContext('2d');
        let lineChart = new Chart(ctxLine, {
            type: 'line',
            data: {
                labels: sevenDaysLabels,
                datasets: [
                    {
                        label: '访问量',
                        data: sevenDaysVisits,
                        borderColor: 'rgba(59, 130, 246, 1)',
                        backgroundColor: 'rgba(59, 130, 246, 0.2)',
                        fill: false,
                        tension: 0.3,
                        pointBackgroundColor: 'rgba(59, 130, 246, 1)',
                        pointRadius: 4
                    },
                    {
                        label: '独立IP',
                        data: sevenDaysUniqueIps,
                        borderColor: 'rgba(16, 185, 129, 1)',
                        backgroundColor: 'rgba(16, 185, 129, 0.2)',
                        fill: false,
                        tension: 0.3,
                        pointBackgroundColor: 'rgba(16, 185, 129, 1)',
                        pointRadius: 4
                    }
                ]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        display: true,
                        position: 'bottom',
                        labels: {
                            font: {
                                size: getResponsiveFontSize()
                            }
                        }
                    },
                    title: { display: false },
                    datalabels: {
                        anchor: 'end',
                        align: function(context) {
                            // 访问量（datasetIndex 0）在点上方，独立IP（datasetIndex 1）在点下方
                            return context.datasetIndex === 0 ? 'end' : 'start';
                        },
                        color: '#333',
                        font: {
                            weight: 'bold',
                            size: getResponsiveFontSize()
                        },
                        offset: function(context) {
                            // 访问量往上偏移，独立IP往下偏移
                            return context.datasetIndex === 0 ? -8 : 8;
                        },
                        formatter: function(value) {
                            return value;
                        }
                    }
                },
                scales: {
                    x: {
                        ticks: {
                            font: {
                                size: getResponsiveFontSize()
                            },
                            padding: 16,
                            labelOffset: 8
                        }
                    },
                    y: {
                        beginAtZero: true,
                        suggestedMax: Math.max(...sevenDaysVisits, ...sevenDaysUniqueIps) * 1.2,
                        ticks: {
                            font: {
                                size: getResponsiveFontSize()
                            }
                        }
                    }
                }
            },
            plugins: [ChartDataLabels]
        });
        // 窗口大小变化时自适应刷新字体
        window.addEventListener('resize', () => {
            mainChart.options.plugins.legend.labels.font.size = getResponsiveFontSize();
            mainChart.options.plugins.datalabels.font.size = getResponsiveFontSize();
            mainChart.options.scales.x.ticks.font.size = getResponsiveFontSize();
            mainChart.options.scales.y.ticks.font.size = getResponsiveFontSize();
            mainChart.update();
            // 折线图字体自适应
            lineChart.options.plugins.legend.labels.font.size = getResponsiveFontSize();
            lineChart.options.plugins.datalabels.font.size = getResponsiveFontSize();
            lineChart.options.scales.x.ticks.font.size = getResponsiveFontSize();
            lineChart.options.scales.y.ticks.font.size = getResponsiveFontSize();
            lineChart.update();
        });

        // 分页AJAX加载
        function loadVisitRecords(url) {
            const visitRecordsDiv = document.getElementById('visit-records');
            // 显示加载中
            visitRecordsDiv.innerHTML = '<div style="text-align:center;padding:30px;">加载中...</div>';
            fetch(url)
                .then(res => res.text())
                .then(html => {
                    visitRecordsDiv.innerHTML = html;
                    bindVisitRecordsEvents();
                });
        }
        function bindVisitRecordsEvents() {
            // 拦截分页a标签
            document.querySelectorAll('#visit-records a').forEach(a => {
                a.addEventListener('click', function(e) {
                    const href = this.getAttribute('href');
                    if (href && href.indexOf('page=') !== -1) {
                        e.preventDefault();
                        // 保留id参数
                        loadVisitRecords('visit_records.php' + href.replace(/^\?/, '?'));
                    }
                });
            });
            // 拦截分页form
            const form = document.querySelector('#visit-records form');
            if (form) {
                form.addEventListener('submit', function(e) {
                    e.preventDefault();
                    const formData = new FormData(form);
                    const params = new URLSearchParams(formData).toString();
                    loadVisitRecords('visit_records.php?' + params);
                });
            }
        }
        // 首次绑定
        bindVisitRecordsEvents();
    </script>

</body>

</html>