<?php
session_start();

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in']!== true) {
    header("Location: ../login/login.php");
    exit;
}
require_once '../db.php';

$linkId = isset($_GET['id']) ? $_GET['id'] : 0;
$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
if ($page < 1) $page = 1;
$limit = 10;
$offset = ($page - 1) * $limit;

// 获取最近访问记录
$stmt = $pdo->prepare("SELECT * FROM statistics WHERE link_id = ? ORDER BY visited_at DESC LIMIT $offset, $limit");
$stmt->execute([$linkId]);
$recentVisits = $stmt->fetchAll(PDO::FETCH_ASSOC);

// 获取总记录数
$stmt = $pdo->prepare("SELECT COUNT(*) AS total_records FROM statistics WHERE link_id = ?");
$stmt->execute([$linkId]);
$totalRecords = $stmt->fetch(PDO::FETCH_ASSOC)['total_records'];
$totalPages = ceil($totalRecords / $limit);

?>
<div class="bg-white p-6 rounded-md shadow-md overflow-x-auto">
    <h3 class="text-lg font-bold text-gray-800 mb-4">最新访问记录</h3>
    <table class="min-w-max">
        <thead>
            <tr>
                <th>时间</th>
                <th>IP</th>
                <th>地区</th>
                <th>设备</th>
                <th>用户类型</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($recentVisits as $visit): ?>
                <tr>
                    <td><?= date('Y-m-d H:i', strtotime($visit['visited_at'])) ?></td>
                    <td><?= htmlspecialchars($visit['ip']) ?></td>
                    <td><?= htmlspecialchars($visit['region']) ?></td>
                    <td><?= htmlspecialchars($visit['device']) ?></td>
                    <td><?= $visit['is_new_user']? '新用户' : '老用户' ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
<div style="text-align: center;">
    <!-- 翻页导航 -->
    <div class="flex justify-between items-center mt-4" style="display: flex;justify-content: center;">
        <div>
            <a href="?id=<?= $linkId?>&page=1"
                class="inline-block bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded-md mr-2 btn">首页</a>
            <?php if ($page > 1): ?>
                <a href="?id=<?= $linkId?>&page=<?= $page - 1 ?>"
                    class="inline-block bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded-md mr-2 btn">上一页</a>
            <?php endif; ?>

            <?php if ($page < $totalPages): ?>
                <a href="?id=<?= $linkId?>&page=<?= $page + 1 ?>"
                    class="inline-block bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded-md mr-2 btn">下一页</a>
            <?php endif; ?>
            <a href="?id=<?= $linkId?>&page=<?= $totalPages ?>"
                class="inline-block bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded-md btn">尾页</a>
        </div>
    </div>

    <div>
        <span class="mr-2">第 <?= $page ?> 页，共 <?= $totalPages ?> 页</span>
        <form action="" method="get" class="flex items-center" style="display: flex;justify-content: center;">
            <input type="hidden" name="id" value="<?= $linkId ?>">
            <input type="number" name="page" min="1" max="<?= $totalPages ?>" value="<?= $page ?>"
                class="border border-gray-300 px-2 py-1 mr-2 rounded-md btn">
            <button type="submit"
                class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded-md btn">跳转</button>
        </form>
    </div>
</div> 