<?php
// 设置 CORS 响应头
header("Access-Control-Allow-Origin: *"); // 允许所有源访问，生产环境建议指定具体的源
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");

    
    
require_once './db.php';

// 获取客户端IP
function getClientIp() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        return $_SERVER['REMOTE_ADDR'];
    }
}

// 简单的地区检测（实际应用中应使用更精确的IP定位服务）
// 使用百度API获取地区信息
function getRegion($ip) {
    if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE)) {
        // 公共IP，调用百度API获取地理位置
        $url = "https://opendata.baidu.com/api.php?query={$ip}&co=&resource_id=6006&oe=utf8";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        $response = curl_exec($ch);
        curl_close($ch);
        
        if ($response) {
            $data = json_decode($response, true);
            if (isset($data['data'][0]['location'])) {
                return $data['data'][0]['location'];
            }
        }
        
        return 'Unknown';
    }
    
    // 本地私有IP地址
    return 'Local Network';
}

// 检测设备类型
function getDevice() {
    $userAgent = $_SERVER['HTTP_USER_AGENT'];
    
    if (preg_match('/Mobile|Android|iP(hone|od|ad)|IEMobile|BlackBerry/', $userAgent)) {
        return '手机';
    } elseif (preg_match('/Tablet|iPad/', $userAgent)) {
        return '平板';
    } else {
        return '电脑';
    }
}

// 处理统计数据
if (isset($_GET['link'])) {
    $urlKey = $_GET['link'];
    
    // 获取IP信息
    $ip = getClientIp();
    $region = getRegion($ip);
    $device = getDevice();
    
    // 检查是否为新用户
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM statistics WHERE ip = ? AND visited_at > DATE_SUB(NOW(), INTERVAL 30 DAY)");
    $stmt->execute([$ip]);
    $is_new_user = $stmt->fetchColumn() == 0 ? 1 : 0;
    
    // 插入统计数据
    $stmt = $pdo->prepare("INSERT INTO statistics (link_id, ip, region, device, is_new_user, visited_at) 
                          SELECT id, ?, ?, ?, ?, NOW() FROM links WHERE url_key = ?");
    $stmt->execute([$ip, $region, $device, $is_new_user, $urlKey]);
    
    // 返回JSON数据
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'success',
        'data' => [
            'ip' => $ip,
            'region' => $region,
            'device' => $device,
            'new_user' => (bool)$is_new_user
        ]
    ]);
    exit;
}